/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.worldgen;

import com.ferreusveritas.dynamictrees.ModConfigs;
import com.ferreusveritas.dynamictrees.worldgen.BiomeDataBase;
import com.ferreusveritas.dynamictrees.worldgen.TreeGenerator;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class TreeGenCancelEventHandler {
    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onEvent(DecorateBiomeEvent.Decorate event) {
        int dimensionId = event.getWorld().field_73011_w.getDimension();
        BiomeDataBase dbase = TreeGenerator.getTreeGenerator().getBiomeDataBase(dimensionId);
        if (dbase != TreeGenerator.DIMENSIONBLACKLISTED && !ModConfigs.dimensionBlacklist.contains(dimensionId)) {
            Biome biome = event.getWorld().func_180494_b(event.getPos());
            switch (event.getType()) {
                case CACTUS: {
                    if (ModConfigs.vanillaCactusWorldGen) break;
                }
                case BIG_SHROOM: 
                case TREE: {
                    if (!dbase.getEntry(biome).shouldCancelVanillaTreeGen()) break;
                    event.setResult(Event.Result.DENY);
                }
            }
        }
    }
}

